package w83b.w83bManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import w83b.w83bBeans.W83bNuevaIncidenciasBean;



// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIIncidencias.
 */
public interface W83bIIncidencias {
	
	/**
	 * Buscar incidencias.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param) throws Exception;
	
	/**
	 * Contar incidencias.
	 *
	 * @param param the param
	 * @return the java.lang. integer
	 * @throws Exception the exception
	 */
	public java.lang.Integer contarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param) throws Exception;
	
	/**
	 * Buscar delegados incidencias.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * No existe dni delegados.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List noExisteDniDelegados(java.util.List param) throws Exception;	
	
	/**
	 * Insertar incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Insertar incidencia subsanacion.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarIncidenciaSubsanacion(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Existe incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String existeIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Existe acta.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String existeActa(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Validar fecha entrada incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaEntradaIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Detalle incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the w83b nueva incidencias bean
	 * @throws Exception the exception
	 */
	public W83bNuevaIncidenciasBean detalleIncidencia(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Actualizar incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String actualizarIncidencia(W83bNuevaIncidenciasBean incidencia,boolean actaParcial)throws Exception;
	
	/**
	 * Descargar documento incidencias.
	 *
	 * @param idDocumento the id documento
	 * @return the w83b.w83b beans. w83b doc bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bDocBean descargarDocumentoIncidencias(String idDocumento)throws Exception;
	
	/**
	 * Borrado fisico incidencias.
	 *
	 * @param listIncidencia the list incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String borradoFisicoIncidencias(ArrayList listIncidencia)throws Exception;
	
	/**
	 * Borrado fisico incidencias.
	 *
	 * @param listIncidencia the list incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String borradoFisicoIncidenciasSoloIncidencias(ArrayList listIncidencia)throws Exception;
	
	/**
	 * Validado de Borrado fisico incidencias.
	 *
	 * @param listIncidencia the list incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarBorradoFisicoIncidencias(ArrayList listIncidencia)throws Exception;
	
	/**
	 * Validacin masiva de incidencias.
	 *
	 * @param listIncidencia the list incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaIncidencias(ArrayList listIncidencia)throws Exception;
	/**20150520
	 * validacion masiva de incidencias.
	 *
	 * @param listIncidencia the list incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaIncidencias(ArrayList listIncidencia, String resultado)throws Exception;
	
	/**
	 * Carga tipos documento incidencias.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List cargaTiposDocumentoIncidencias(HashMap param) throws Exception;
	
	/**
	 * Recuperar escrutinio diferencias.
	 *
	 * @param param the param
	 * @return the hash map
	 * @throws Exception the exception
	 */
	public HashMap recuperarEscrutinioDiferencias(java.util.List param)throws Exception;
	
	public W83bNuevaIncidenciasBean devolverNCentroTrabajo(W83bNuevaIncidenciasBean incidencia)throws Exception;
	
	/**
	 * Actualiza la informacin de acuse de recibo de una lista de comunicaciones de incidencias
	 * @param listaComunicacionesAcuse List
	 * @throws Exception the exception
	 */
	public void actualizarDatosAcusesComunicacionIncidencias (ArrayList listaComunicacionesAcuse)throws Exception;
}
